let express = require('express');
const path = require("path");
const app = express();
const flash=  require('connect-flash');
const session = require('express-session');
const sequelize= require('./util/db');
const user= require('./models/user');
const logger=require('./util/logger');
app.set("view engine", "ejs");
app.set("views", "./views");
let menuRouter=require('./routes/menu');
const adminRouter=require('./routes/admin');
const errors=require('./util/error');
app.use(flash());
app.use(session({
  secret:'goodone@123',
  resave: false,
   saveUninitialized:false,
   cookie: {
    path    : '/',
    maxAge  : 24*60*60*1000
  },
}));
app.use(express.urlencoded({ extended: true }));
app.use(express.json());
app.use('/',express.static(path.join(__dirname, "public")));
app.use('/admin',express.static(path.join(__dirname, "adminPublic")));
app.use('/admin',adminRouter);
app.use('/', menuRouter);

app.locals.domain="https://patientcare24x7.com/"
// app.locals.domain="http://localhost:5555/"

app.locals.mob="+919451957460"
sequelize.sync({alter:false}).then(result=>{
  const port = process.env.PORT || 5555;
  app.listen(port, () => {
    logger.info(`i am lisening at Port ${port}`);
  });
}).catch(err=>{
  logger.error(err);
});

