const Sequelize = require('sequelize');
const sequelize = require('../util/db');
const jobsmaster = sequelize.define('jobsmaster', {

    patientName: {
        type: Sequelize.STRING,
        allowNull: false
    },
    mobileNumber: {
        type: Sequelize.STRING,
        allowNull: false
    },
    alterMobileNum: {
        type: Sequelize.STRING,
        allowNull: false
    },
    patientLocality: {
        type: Sequelize.STRING,
        allowNull: false
    },
    Charges:{
        type: Sequelize.STRING,
        allowNull: false
    },
    jobHeading:{
        type: Sequelize.STRING,
        allowNull: false
    },
    discription:{
        type:Sequelize.STRING,
        allowNull:false
    },
    address:{
        type:Sequelize.STRING,
        allowNull:false
    },
    staffReqId:{
        type:Sequelize.STRING,
        allowNull:false
    },
    jobid:{
        type:Sequelize.STRING,
        allowNull:false
    },
    staffType:{
        type:Sequelize.STRING,
        allowNull:false
    },
    staffGender:{
        type:Sequelize.STRING,
        allowNull:false
    },
    city:{
        type:Sequelize.STRING,
        allowNull:false
    },
    pincode:{
        type:Sequelize.STRING,
        allowNull:false
    },
    state:{
        type:Sequelize.STRING,
        allowNull:false
    }

});


//===============================================================================



const staffRequest = sequelize.define('staffRequest', {

    Name: {
        type: Sequelize.STRING,
        allowNull: false
    },
    mobileNumber: {
        type: Sequelize.STRING,
        allowNull: false
    },
    status:{
        type:Sequelize.STRING,
        allowNull:false,
        defaultValue: '0'
    },
    message: {
        type: Sequelize.TEXT,
        allowNull: true
    },
    city:{
        type: Sequelize.TEXT,
        allowNull: false
    }

});


const jobAppliedStaff = sequelize.define('jobAppliedStaff', {

    jobid: {
        type: Sequelize.STRING,
        allowNull: false
    },
    joburl: {
        type: Sequelize.STRING,
        allowNull: false
    },
    staffid:{
        type:Sequelize.STRING,
        allowNull:false,
        defaultValue: '0'
    },
    staffurl: {
        type: Sequelize.TEXT,
        allowNull: true
    }

});




const staffMaster = sequelize.define('staffMaster', { 
    userId:{
        type: Sequelize.STRING,
        allowNull: false 
    },
    rank: {
        type: Sequelize.STRING,
        allowNull: true,
        
    },
    staffMobNum: {
        type: Sequelize.STRING,
        allowNull: false
    },
    staffAltMobNum: {
        type: Sequelize.STRING,
        allowNull: true
    },
    staffCharges:{
        type: Sequelize.STRING,
        allowNull: false
    },
    aboutStaff: {
        type: Sequelize.TEXT,
        allowNull: false
    },
   
    prefLocation: {
        type: Sequelize.STRING,
        allowNull: false
    },
    
    addressLocation: {
        type: Sequelize.STRING,
        allowNull: false
    },
    fullAddress: {
        type: Sequelize.STRING,
        allowNull: false
    },
    profilPic: {
        type: Sequelize.STRING,
        allowNull: false
    },
    aadharFront: {
        type: Sequelize.STRING,
        allowNull: false
    },
    aadharBack: {
        type: Sequelize.STRING,
        allowNull: false
    },
    staffUrl: {
        type: Sequelize.STRING,
        allowNull: false
    },
    status: {
        type: Sequelize.STRING,
        allowNull: false
    },
    Experience: {
        type: Sequelize.STRING,
        allowNull: false
    },
    StaffQuali: {
        type: Sequelize.STRING,
        allowNull: false
    },
    StaffDesig: {
        type: Sequelize.STRING,
        allowNull: false
    },
    
     fullTime:{
        type:Sequelize.STRING,
     },
     gender:{
        type: Sequelize.STRING,
        allowNull: false
    },
    city:{
        type: Sequelize.STRING,
        allowNull: false
    },
    
    createdBy: {
        type: Sequelize.STRING,
        allowNull: false
    }

});
exports.jobsmaster = jobsmaster;
exports.staffMaster = staffMaster;
exports.staffRequest = staffRequest;
exports.jobAppliedStaff=jobAppliedStaff;




