
const Sequelize = require('sequelize');
const sequelize = require('../util/db');
const validator = require("validator");

const User = sequelize.define('user', {
    _id: {
        type: Sequelize.INTEGER,
        autoIncrement: true,
        allowNull: false,
        primaryKey: true
    },
    email: {
        type: Sequelize.STRING,
        allowNull: false,

    },
    gender:{
        type: Sequelize.STRING,
        allowNull: false 
    },
    password: {
        type: Sequelize.STRING,
        allowNull: false
    },
    fullname: {
        type: Sequelize.STRING,
        allowNull: false

    },
    city:{
        type:Sequelize.STRING,
        allowNull:false
    },
    userType: {
        type: Sequelize.STRING,
        allowNull: false

    },
    createdBy: {
        type: Sequelize.STRING,
        allowNull: false
    }


});

const validateUser = (User) => {
    if (!validator.isEmail(User.email)) return "Invalid Email";
    else if (!validator.isAlpha(User.fname, 'en-GB')) return "Only Alphabate allowed in First Name. ";
    else if (!validator.isAlpha(User.lname, 'en-GB')) return "Only Alphabate allowed in Last Name.";
    return "1"
}

const Locality = sequelize.define('locality', {
   
    localityName: {
        type: Sequelize.STRING,
        allowNull: false
    },
    city:{
        type: Sequelize.STRING,
        allowNull: false 
    },
    state:{
        type: Sequelize.STRING,
        allowNull: false 
    },
    pincode:{
        type: Sequelize.STRING,
        allowNull: false
    },
    createdBy: {
        type: Sequelize.STRING,
        allowNull: false
    }
});
const city = sequelize.define('city',{
    cityName:{
        type:Sequelize.STRING,
        allowNull:false
    },state:{
        type:Sequelize.STRING,
        allowNull:false
    },
    status: {
        type: Sequelize.BOOLEAN,
        defaultValue: false  // Sets default value to false
      }

});

const validateLocality = (Locality) => {

    if (validator.isEmpty(Locality.locality)) return "Please Enter Locality !";

    return true;
}
const qualification = sequelize.define('qualification', {
    _id: {
        type: Sequelize.INTEGER,
        autoIncrement: true,
        allowNull: false,
        primaryKey: true

    },
    qualiName: {
        type: Sequelize.STRING,
        allowNull: false
    },
    createdBy: {
        type: Sequelize.STRING,
        allowNull: false
    }
});




exports.User = User;
exports.validateUser = validateUser;
exports.Locality = Locality;
exports.validateLocality = validateLocality;
exports.qualification=qualification;
exports.city=city;

