const express = require("express");
const axios = require('axios').default;
const { Locality, Subjects, User, validateUser, qualification } = require("../models/user");
const { staffMaster, jobsmaster, tutorrequest, jobAppliedTutors } = require("../models/adminModels");
const router = express.Router();
const { unLinkFile } = require("../util/fileUnlink");
const spaceReplacer = require("../util/usefulFunctions");
const multer = require("multer");
const sharp = require("sharp");
const bcrypt = require("bcrypt");
const storage = multer.memoryStorage();
const upload = multer({ storage });
var uniqid = require("uniqid");
const logger = require("../util/logger");
const sequelize = require('../util/db');
const adminAuth = require("../util/authAdmin");
const { bulkmail } = require("../util/bulkMail");
const Sequelize = require('sequelize');
const Op = Sequelize.Op;
const nodemailer = require('nodemailer');



router.get("/dash", adminAuth, (req, res) => {
  console.log("Ram", req.session.adminLoggedin);
  res.render("admin/index");
});

router.get("/logout", (req, res) => {
  console.log("sita", req.session.adminLoggedin);
  delete req.session.adminLoggedin;
  res.redirect("/admin/login");

});

router.get("/registerUser", (req, res) => {
  let msg = req.flash("notify");
  if (msg.length > 0) {
    msg = msg[0];
  } else {
    msg = null;
  }
  res.render("admin/createUser", { user: req.session.isLoggedin, msg: msg });
});

router.post("/registerUser", adminAuth, async (req, res) => {
  

  const user = await User.findOne({ where: { email: req.body.email } });
  if (user !== null) {
    req.flash("notify", "Email Already Exist");

    return res.redirect("/admin/registerUser");
  }
  var salt = bcrypt.genSaltSync(10);
  const hash = bcrypt.hashSync(req.body.password, salt);
  req.body.fullname = req.body.fname + " " + req.body.lname;

  await User.create({
    email: req.body.email,
    fullname: req.body.fullname,
    password: hash,
    gender:req.body.gender,
    city:req.body.city,
    createdBy: req.body.userId,
    userType: "2"
  }).then((result) => {
    return res.redirect("/admin/login");
  })
    .catch((err) => {
      req.flash("notify", "Something went wrong check logger.");

      logger.error(err);
    });
});



router.get("/login", async (req, res) => {
  let msg = req.flash("notify");
  if (msg.length > 0) {
    msg = msg[0];
  } else {
    msg = null;
  }
  res.render("admin/sign-in", { msg: msg });

});

router.post("/login", async (req, res) => {
  // res.send(req.body);
  const email = req.body.email;
  const user = await User.findOne({ where: { email } });
  if (user) {
    var check = await bcrypt.compare(req.body.password, user.password);
    if (check) {
      req.session.adminLoggedin = user;
      console.log(req.session.adminLoggedin)
      res.redirect("/admin/dash");

    } else {
      req.flash("notify", "Invalid User Name password");
      res.redirect("/admin/login");
    }
  } else {
    req.flash("notify", "Invalid User Name password");

    res.redirect("/admin/login");
  }
});




router.get("/addSubjects", adminAuth, async (req, res) => {

  res.render("admin/addSubjects");
});



router.post("/addSubjects", async (req, res) => {


  const subName = await Subjects.findOne(
    { where: { SubjectName: req.body.subjects } }
  );
  if (subName) return res.status(200).send("already exist");
  const subReturn = await Subjects.create({
    SubjectName: req.body.subjects,
    createdBy: 'Raj'
  });

  if (subReturn) {
    return res.status(200).send("Saved");
  }
});



router.post("/getAllSubjects", async (req, res) => {
  const allSubjects = await Subjects.findAll();

  if (allSubjects) {
    return res.send(allSubjects);
  }
});

router.post("/deleteSubject", async (req, res) => {
  const result = await Subjects.destroy({ where: { SubjectName: req.body.SubjectName } });
  if (result.n) {
    return res.status(200).send("1");
  } else {
    return res.status(200).send("0");
  }
});

// ============================================== Add Qalification ================================================================

router.get("/getAllQuali", adminAuth, async (req, res) => {
  const quali = await qualification.findAll();
  console.log("========="+JSON.stringify(quali));
  res.render("admin/addQuali" , { data: quali });
});


router.post("/getAllQuali", async (req, res) => {
    let qualiName= req.body.qualiName;
    let classReturn;
    // console.log("========="+classN);
  const quli = await qualification.findOne(
    { where: { qualiName: qualiName } }
  );

  // console.log("Ramm jiii=="+className);
  if (quli){
    // console.log("inn iff")
    return res.status(200).send("already exist");

  } else{
    // console.log("in else="+classN +"===="+req.session.adminLoggedin.fullname)
   qualiReturn = await qualification.create({
    qualiName: qualiName,
    createdBy: req.session.adminLoggedin.fullname
  });
}
  if (qualiReturn) {
    return res.status(200).send("Saved");
  }
});


router.post("/deleteQuali", async (req, res) => {
  const result = await qualification.destroy({ where: { qualiName: req.body.qualiName } });
  if (result.n) {
    return res.status(200).send("1");
  } else {
    return res.status(200).send("0");
  }
});


//=================================================================================================================================

router.get("/createLocality", adminAuth, (req, res) => {
  res.render("admin/createLocality");
});

router.post("/addLocality", async (req, res) => {
  const locName = await Locality.findOne(
    { where: { localityName: req.body.locality } }
  );
  if (locName) return res.status(200).send("already exist");
  const locReturn = await Locality.create({
    localityName: req.body.locality,
    createdBy: 'Raj'
  });

  if (locReturn) {
    return res.status(200).send("Saved");
  }
});
router.post("/getAllLocality", async (req, res) => {
  const locReturn = await Locality.findAll();

  if (locReturn) {
    return res.send(locReturn);
  }
});

router.post("/deleteLocality", async (req, res) => {
  const result = await Locality.destroy({ where: { localityName: req.body.locality } });
  if (result.n) {
    return res.status(200).send("1");
  } else {
    return res.status(200).send("0");
  }
});

// ====================================Staff rgistration======================================================

const uploads = upload.fields([{ name: "gallery", maxCount: 1 },{ name: 'aadhar', maxCount: 1 }]);
router.post("/staffRegi",uploads,async (req, res) => {
  // console.log("==================="+JSON.stringify(req.body));
  
  unid = uniqid();
  let fname = spaceReplacer(req.body.fullname);
  let loc = spaceReplacer(req.body.location);
  let profession = spaceReplacer(req.body.profession);
  let stCity =req.body.city.trim().toLowerCase();
  // console.log("subs====="+subs);
  // console.log("subsexp====="+req.body.subexp);
  // console.log("subs[0]====="+subs[0]);
  var salt = bcrypt.genSaltSync(10);
  const hash = bcrypt.hashSync(req.body.password, salt);
  let src =  fname + "-" + profession + "-in-" + loc + "-"+stCity+"-"+unid+".jpeg";
  src = src.toLowerCase();
  let aadharSrc = unid +"-"+fname+"-aadhar-front-"+stCity+".jpeg";
  aadharSrc = aadharSrc.toLowerCase();
  let url = `${fname}-${profession}-in-${loc}-${stCity}-${unid}.html`.toLowerCase();
  // console.log(req.body.gallery+"===============");
  var matches = req.body.gallery.match(/^data:([A-Za-z-+/]+);base64,(.+)$/);
  response = {};
  if (matches.length !== 3) {
    return new Error('Invalid input string');
  }

  response.type = matches[1];
  response.data = new Buffer.from(matches[2], 'base64');
  let decodedImg = response;
  let imageBuffer = decodedImg.data;
  await sharp(imageBuffer)
  .resize({ width: 350, height: 350 })
    .webp({ quality: 80 })
    .toFile("./public/uploads/" + src)
    .then()
    .catch((err) => {
      logger.error(err);
    });


//=====================================================

var matches1 = req.body.aadhar.match(/^data:([A-Za-z-+/]+);base64,(.+)$/);
response1 = {};
if (matches1.length !== 3) {
  return new Error('Invalid input string');
}

response1.type = matches1[1];
response1.data = new Buffer.from(matches1[2], 'base64');
let decodedImg1 = response1;
let imageBuffer1 = decodedImg1.data;
await sharp(imageBuffer1)
.resize({ width: 500, height: 500 })
  .webp({ quality: 80 })
  .toFile("./public/uploads/aa" + aadharSrc)
  .then()
  .catch((err) => {
    logger.error(err);
  });  


  // const classes = (req.body.classes).toString();
  let user = await User.create({
    email: req.body.email,
    password : hash,
    fullname: req.body.fullname,
    city: stCity,
    userType: "S",
    gender:req.body.gender,
    mobileNumber:req.body.mobnum,
    createdBy:req.body.fullname
  });


  let tutor = await staffMaster.create({
    fullname: req.body.fullname,
    userId:user._id,
    gender:req.body.gender,
    staffMobNum: req.body.mobnum,
    staffAltMobNum: req.body.altmobnum,
    staffCharges: req.body.fee,
    aboutStaff: "",
    engSpeaking:req.body.eng,
    // tutorsClasses: classes,
    prefLocation: req.body.prefArea,
    // subjectExp: req.body.subexp,
    addressLocation: req.body.location,
    fullAddress: req.body.address,
    StaffDesig:req.body.profession,
    postalCode: req.body.pincode,
    // teachingMode:req.body.teachMode.toString(),
    
    Experience: req.body.exper,
    StaffQuali: req.body.hq,
    profilPic: src,
    staffUrl: url,
    aadharFront:aadharSrc,
    aadharBack:"",
    city:stCity,
    // digitalPen:req.body.digitalPen,
    fullTimeTeacher:req.body.fulltime,
    homeWork:req.body.homework,
    status: 'true',
    createdBy: "raj",

  });
  if (tutor._options.isNewRecord) {
    res.send("successfully registered.")
  }
});
//=============================================================================================





router.get("/getAllTutorData", adminAuth, async (req, res) => {
  const tutorAll = await tutorsMaster.findAll({
    attributes: [
      "id",
      "tutorsFullName",
      "tutorsMobNum",
      "Highquali",
      "subjectExp",
      "tutorsAltMobNum",
      "tutorFee",
      "tutorsClasses",
      "prefLocation",
      "addressLocation",
      "tutorsEmail",
      "profilPic",
      "tutorUrl",
      "status",
      "Experience",
      "review"
    ],
    order: [
      ["id", "DESC"]
    ]
  });



  if (tutorAll == null) {
    logger.info("Not found!");
  } else {

    res.render("admin/allTutors", { data: tutorAll });

  }

});


router.post("/getAllTutorData", async (req, res) => {

  const tutorAll = await tutorsMaster.findAll({
    attributes: [
      "id",
      "tutorsFullName",
      "tutorsMobNum",
      "Highquali",
      "subjectExp",
      "tutorsAltMobNum",
      "tutorFee",
      "tutorsClasses",
      "prefLocation",
      "addressLocation",
      "tutorsEmail",
      "profilPic",
      "tutorUrl",
      "status",
      "Experience"

    ],
  });
  if (tutorAll == null) {
    logger.info("Not found!");
  } else {

    res.status(200).send(tutorAll);

  }

});

router.delete("/deleteTutor/:id", async (req, res) => {
  var table = await tutorsMaster.findByPk(req.params.id);
  console.log(table);
  unLinkFile(table.dataValues.profilPic);
  const x = await tutorsMaster.destroy({ where: { id: req.params.id } });
  res.send("1");

});



router.get("/getTutorsRequest", adminAuth, async (req, res) => {
  const tutReq = await tutorrequest.findAll({
    order: [
      ["id", "DESC"]
    ],
  });
  res.render("admin/tutorsRequest", { data: tutReq });
});


router.get("/postJob", adminAuth, async (req, res) => {
  let msg = req.flash("jobpost");
  if (msg.length > 0) {
    msg = msg[0];
  } else {
    msg = null;
  }
  const loc = await Locality.findAll();
  res.render("admin/jobPost", { loc: loc, tutReq: "", msg: msg });
});


router.get("/postJob:id", adminAuth, async (req, res) => {
  let msg = req.flash("notify");
  if (msg.length > 0) {
    msg = msg[0];
  } else {
    msg = null;
  }
  const tutReq = await tutorrequest.findOne({
    where: { id: req.params.id }
  });
  const loc = await Locality.findAll();
  const sub = await Subjects.findAll();
  res.render("admin/jobPost", { loc: loc, sub: sub, tutReq: tutReq, msg: msg });
});

router.post("/postJob", async (req, res) => {
  
    
   let staffType = req.body.staffType.toString();
    staffType = staffType.trim().replace(/ /g, '-').toLowerCase();
    let city = req.body.city.toString().trim().replace(/ /g, '-').toLowerCase();
    let jobid = `${staffType}-part-time-job-vacancy-paitents-home-in-${spaceReplacer(req.body.location)}-${city}-${uniqid()}`;
    let jobMast = await jobsmaster.create({
      patientName: req.body.fullName,
      mobileNumber: req.body.MobileNum,
      alterMobileNum: req.body.altMobNum,
      patientLocality: req.body.location,
      Charges:req.body.Charges,
      staffType:req.body.staffType,
      staffGender:req.body.GenderPref,
      city:req.body.city,
      jobHeading:"",
      pincode:req.body.pincode,
      state:req.body.state,
      discription: req.body.message,
      address: req.body.address,
      staffReqId: "",
      jobid: jobid
    });



    if (jobMast._options.isNewRecord) {
    //   let mailList = ["rajs01878@gmail.com", "rs802381@gmail.com"];
    //   let tutorsMail = await tutorsMaster.findAll({
    //     attributes: [
    //       "tutorsEmail"
    //     ],
    //     where: {
    //       status: "true",
    //       prefLocation: { [Op.like]: `%${req.body.location}%` },
    //       tutorsClasses: { [Op.like]: `%${req.body.classes}%` }
    //     },
    //     order: [

    //       [sequelize.fn('COALESCE', sequelize.col('rank'), 'NULL'), 'ASC'],
    //       ['id', 'DESC']
    //     ]
    //   });

    //   bulkmail(tutorsMail, jobid, req.body.location, req.body.classes, req.body.message, subs);
      req.flash("jobpost", "Job Posted.");
      res.redirect("/admin/allJobPost");
    } else {
      req.flash("jobpost", "Something went wrong! Try Again");
      res.redirect("/admin/allJobPost");
    }
  }

);

router.get("/allJobPost", adminAuth, async (req, res) => {

  const data = await jobsmaster.findAll(
    {
      order: [
        ["id", "DESC"],]
    });

  res.render("admin/alljobpost.ejs", { "data": data });
});

router.get("/allJobAppliedTutors", adminAuth, async (req, res) => {
  const result = await sequelize.query("SELECT jb.jobid,jb.tutorid,jb.joburl,jb.tutorurl,jb.createdAt,tm.tutorsFullName,tm.tutorsMobNum,jm.parentName,jm.mobileNumber,jm.studentLocality FROM `jobAppliedTutors` as jb join `tutorsMasters` as tm on jb.tutorid=tm.id join `jobsmasters` as jm on jm.id=jb.jobid;");
  res.render("admin/alltutorsAppliedjob.ejs", { data: result });
});


router.get("/allJobApplied/:id", adminAuth, async (req, res) => {
  let jobId = req.params.id;

  const result = await sequelize.query("SELECT jb.jobid,jb.tutorid,jb.joburl,jb.tutorurl,jb.createdAt,tm.tutorsFullName,tm.tutorsMobNum,jm.parentName,jm.mobileNumber,jm.studentLocality FROM `jobAppliedTutors` as jb join `tutorsMasters` as tm on jb.tutorid=tm.id join `jobsmasters` as jm on jm.id=jb.jobid where jm.id=" + jobId);

  res.render("admin/alltutorsAppliedjob.ejs", { data: result });
});


//======================================jobAppliedBy=======================================================

router.get("/jobAppliedBy/:id", adminAuth, async (req, res) => {
  let tutorId = req.params.id;
  const result = await sequelize.query("SELECT jb.jobid,jb.tutorid,jb.joburl,jb.tutorurl,jb.createdAt,tm.tutorsFullName,tm.tutorsMobNum,jm.parentName,jm.mobileNumber,jm.studentLocality FROM `jobAppliedTutors` as jb join `tutorsMasters` as tm on jb.tutorid=tm.id join `jobsmasters` as jm on jm.id=jb.jobid where jb.tutorid=" + tutorId);

  res.render("admin/jobsappliedby.ejs", { data: result });

});

//===========================================================================================================================================


router.post("/addReview", async (req, res) => {

  await tutorsMaster.update({ review: req.body.review }, {
    where: {
      id: req.body.tutorid
    }
  });
  res.redirect("/admin/getAllTutorData");
});

//============================================================================================================
router.post("/sendNotif", async (req, res) => {
  let textMsg = "Home Tutor Lucknow";
  let {data,link} = req.body;
  let apiKey = encodeURI('Mzg0OTU1MzI3NTYzMzg3NTY5Njc2MTM2Nzc3MzVhMzU=');
  let sender = encodeURI('390499');
 
   
  
  data.map(async (x) => {
    let tData = await tutorsMaster.findOne({ where: { id: x } });
  let encoded_message = encodeURI( textMsg+" added new Tuition Job, Apply at: " + link + " . Redink Initiative");
    const tlClient = axios.create({
      baseURL: "https://api.textlocal.in/",
      params: {
        apiKey: apiKey, //Text local api key
        sender: sender
      }
    });
    const params = new URLSearchParams();
    params.append("numbers", [parseInt("91"+tData.tutorsMobNum)]);
    params.append(
      "message",
      encoded_message
    );
   let smsRes = await tlClient.post("/send", params);
   logger.info(smsRes);
   logger.info("sms ==="+smsRes.data.status);
      
     var transporter = nodemailer.createTransport({
      host: "mail.hometutorlucknow.com",
      port: 465,
      secure: true,
      auth: {
        user: 'hr@hometutorlucknow.com',
        pass: '9453559003Rp'
      }
    });
    var mailOptions = {
      from: '"Home Tuition Job For You" <hr@hometutorlucknow.com>',
      to: tData.tutorsEmail,
      subject: `Urgent Requirement for the role of Home Tutor Or Tuition teacher in Lucknow`,
      html: `<div style=" align-items: center;margin-left: 20px ">
      <div style="display: flex; justify-content: center;">
         <img src="https://hometutorlucknow.com/assets/images/logo/01.png" alt="home tutor lucknow logo"/>
      </div>
      <div style="display: flex; justify-content: center;">
          <h2>Tuition job recommendations based on your Hometutorlucknow profile</h2>
      </div>
      <div style="margin-left: 20px;">
          <div style="display: flex; justify-content: space-between; ">
                  <h3>Hi ${tData.tutorsFullName} new tuition job is posted on <a href="https://hometutorlucknow.com/" target="_blank">hometutorlucknow.com</a> in your prefered area where you want to teach.
                  </h3>
                  

              </div>
              <h3>
                   Click the link below to view the details and apply for job or share the link to our <br/><strong> Whatsapp Number <a href="https://wa.me/+918005472497" target="_blank">8005472497</a> </strong>
                  </h3>
              <div >
             <a href="${link}" target="_blank" style="height: 20px; width:100px;background-color: darkorange; padding: 10px; border-radius: 5px; color:white " >View Tuition Details</a>
                 
              </div>
      </div>
  </div> `
    };
    transporter.sendMail(mailOptions, function (error, info) {
      if (error) {
        logger.error(error.message);

      } else {
        succ = { "message": "Thank you for contacting Us – we will get back to you soon!", "status": "success" }
        logger.info('Email sent: ' + info.response + ' Send to Email='+ tData.tutorsEmail);
        console.log(succ);
      }
    });


 });

      
    
 res.status(200).send({"data":"Mails And Emails "});  

  //=========================================================================================

  //   var data = JSON.stringify({
  //   "apikey": apiKey,
  //   "numbers": toNumbers.join(','),
  //   "sender": sender,
  //   "message":encoded_message
  // });

  // var config = {
  //   method: 'post',
  //   url: "https://api.textlocal.in/send/",
  //   headers: { 
  //     'Content-Type': 'application/json', 
  //   },
  //   data : data
  // };

  // axios(config)
  // .then(function (response) {
  //   console.log(JSON.stringify(response.data));
  //   res.send("Ram=="+response.data)
  // })
  // .catch(function (error) {
  //   console.log(error);
  //   res.send("Ram=="+error.message)
  // });


});









module.exports = router;
