const express = require("express");
const sequelize = require('../util/db');
const router = express.Router();
const logger = require("../util/logger");
const nodemailer = require('nodemailer');
const {qualification, User, city} = require("../models/user");
const { tutorsMaster, jobsmaster, tutorrequest, jobAppliedTutors, reviewMst, staffMaster } = require("../models/adminModels");
const { getAllTutors } = require("../util/reuseables");
const Sequelize = require('sequelize');
const Op = Sequelize.Op;
const bcrypt = require("bcrypt");
const auth = require("../util/auth");
const { getActiveCities } = require("../controller/contrroller");
const domain = "https://hometutorlucknow.com/";


router.get('/favicon.ico', async (req, res) => {
  res.render("404");
});
router.get('/404', async (req, res) => {
  res.render("404");
});

router.get("/contact-us", auth, (req, res) => {
  res.render("contact-us");

});
router.get("/about", auth, (req, res) => {
  res.render("about",{allLoc: req.allLoc});
});
router.get("/terms", auth, (req, res) => {
  res.render("terms",{allLoc: req.allLoc});
});

router.get("/", auth, async (req, res) => {
 
  staffMaster.belongsTo(User, { foreignKey: 'userId' });
  User.hasOne(staffMaster, { foreignKey: 'userId' });
  
      const {rows} = await staffMaster.findAndCountAll({
        attributes: [
          'userId', 
          'StaffDesig', 
          'Experience', 
          'staffCharges', 
          'StaffQuali',
          'profilPic', 
          'staffUrl', 
          'addressLocation'
        ],
        include: [{
          model: User,
          attributes: ['fullname', ['city', 'city']],  // Alias for city
        }],
        where: {
          status:"true"
          
        },
        order: [['createdAt', 'DESC']],  // Order by userId in ascending order
        limit: 12  // Limit to 12 results
          // Offset by 1
      });

  const cities = await getActiveCities();
  
  // console.log(JSON.stringify(cities));
  // res.render("index", { data: tutorAll,allLoc: req.allLoc});
  res.render("index",{cities,data:rows});

});

router.get("/register-as-medical-staff", auth, async (req, res) => {
  
  
  const quali = await qualification.findAll({
    attributes: ['qualiName']
  })
  // const cla = await Classes.findAll({
  //   attributes: ['ClassesName']
  // })
  
  res.render("staffRegister",{quali} );
});


router.get("/nurses", auth, async (req, res) => {
  let noOfRes = "";
  let landingPageLimit =30;
  const page = +req.query.page || 1;

  staffMaster.belongsTo(User, { foreignKey: 'userId' });
  User.hasOne(staffMaster, { foreignKey: 'userId' });
  
      const {count,rows} = await staffMaster.findAndCountAll({
        attributes: [
          'userId', 
          'StaffDesig', 
          'Experience', 
          'staffCharges', 
          'StaffQuali',
          'profilPic', 
          'staffUrl', 
          'addressLocation'
        ],
        include: [{
          model: User,
          attributes: ['fullname', ['city', 'city']],  // Alias for city
        }],
        where: {
          
          StaffDesig:{
            [Op.like]: '%Nurse%'
          },
          status:"true"
          
        },
        order: [['createdAt', 'DESC']],  // Order by userId in ascending order
        limit: landingPageLimit,  // Limit to 12 results
        offset: ((page-1)*landingPageLimit)   // Offset by 1
      });

      

  res.render("staffList.ejs",{data:rows,count,stafftype:"Nurse",city:"",locality:""});

});




// SEO-friendly route for fetching physiotherapist profiles based on city and locality
router.get('/physiotherapists', async(req, res) => {
  let landingPageLimit =30;
  const page = +req.query.page || 1;
  let stafftype = "Physiotherapist"
  staffMaster.belongsTo(User, { foreignKey: 'userId' });
  User.hasOne(staffMaster, { foreignKey: 'userId' });
  
      const {count,rows} = await staffMaster.findAndCountAll({
        attributes: [
          'userId', 
          'StaffDesig', 
          'Experience', 
          'staffCharges', 
          'StaffQuali',
          'profilPic', 
          'staffUrl', 
          'addressLocation'
        ],
        include: [{
          model: User,
          attributes: ['fullname', ['city', 'city']],  // Alias for city
        }],
        where: {
          
          StaffDesig:{
            [Op.like]: '%Physiotherapist%'
          },
          status:"true"
          
        },
        order: [['createdAt', 'DESC']],  // Order by userId in ascending order
        limit: landingPageLimit,  // Limit to 12 results
        offset: ((page-1)*landingPageLimit)   // Offset by 1
      });

  res.render("staffList.ejs",{data:rows,count,stafftype,city:"",locality:""});
});


// SEO-friendly route for fetching medical attendant profiles based on city and locality
router.get('/patient-attendants', async(req, res) => {
  
  let landingPageLimit =30;
  const page = +req.query.page || 1;

  staffMaster.belongsTo(User, { foreignKey: 'userId' });
  User.hasOne(staffMaster, { foreignKey: 'userId' });
  
      const {count,rows} = await staffMaster.findAndCountAll({
        attributes: [
          'userId', 
          'StaffDesig', 
          'Experience', 
          'staffCharges', 
          'StaffQuali',
          'profilPic', 
          'staffUrl', 
          'addressLocation'
        ],
        include: [{
          model: User,
          attributes: ['fullname', ['city', 'city']],  // Alias for city
        }],
        where: {
          
          StaffDesig:{
            [Op.like]: '%patient%'
          },
          status:"true"
          
        },
        order: [['createdAt', 'DESC']],  // Order by userId in ascending order
        limit: landingPageLimit,  // Limit to 12 results
        offset: ((page-1)*landingPageLimit)   // Offset by 1
      });

  res.render("staffList.ejs",{data:rows,count,stafftype:"patient attendants",city:"",locality:""});

});

// ===============================================================================================================================

router.get("/medical-jobs/:id", auth, async (req, res) => {
  console.log("=====")
let msg = req.flash("notify");
if (msg.length > 0) {
  msg = msg[0];
} else {
  msg = null;
}
const singleOne = await jobsmaster.findOne({
  where: { jobid: req.params["id"] },
});

console.log(JSON.stringify(singleOne));
res.render("jobdetails", { data: singleOne, msg: msg ,allLoc: req.allLoc });
});


router.get("/physiotherapist-jobs", auth, async (req, res) => {

  const {rows,count} = await jobsmaster.findAndCountAll({
    where:{
      stafftype :"physiotherapist"
    
      },
    order: [
      ["id", "DESC"],],

    limit: 50

    }
  );
    console.log(JSON.stringify(rows))
  res.render("job-result", { data: rows, num: count,loc:"" ,allLoc: req.allLoc });
});

router.get("/nurses-jobs", auth, async (req, res) => {

  const physioJob = await jobsmaster.findAll({
    where:{
      stafftype :"nurse"
    
      },
    order: [
      ["id", "DESC"],],

    limit: 50

    }
  );
  const jobsNumber = await jobsmaster.count();
  res.render("job-result", { data: physioJob, num: jobsNumber,loc:"" ,allLoc: req.allLoc });
});

router.get("/patient-attendent-jobs", auth, async (req, res) => {

  const physioJob = await jobsmaster.findAll({
    where:{
      stafftype :"Patient Attendant"
    
      },
    order: [
      ["id", "DESC"],],

    limit: 50

    }
  );
  const jobsNumber = await jobsmaster.count();
  res.render("job-result", { data: physioJob, num: jobsNumber,loc:"" ,allLoc: req.allLoc });
});







// ==============================Lead Submit===========================================
router.post("/request-a-tutor", async (req, res) => {
  console.log(req.body.name+"=========")
  let tutReq = await tutorrequest.create({
    Name: req.body.name,
    mobileNumber: req.body.monum,
    message: req.body.message,
    city:req.body.city
  });

  if (tutReq._options.isNewRecord) {
    var transporter = nodemailer.createTransport({
      host: "mail.hometutorlucknow.com",
      port: 465,
      secure: true,
      auth: {
        user: 'info@hometutorlucknow.com',
        pass: '9453559003Rp'
      }
    });
    var mailOptions = {
      from: '"👻Tutor Setu " <info@hometutorlucknow.com>',
      to: 'rajs01878@gmail.com',
      subject: 'Home Tutor request Tutor Setu Website',
      html: `Data From Tutor Setu WebSite  Full Name = ${req.body.name} <br/>  Mobile Number = ${req.body.monum} <br/> city = ${req.body.city} <br/> message = ${req.body.message}  <br/>   <br/> `
    };
    transporter.sendMail(mailOptions,  function(error, info){
      if (error) {
        logger.error(error);
         
      } else {
         succ= {"message":"Thank you for contacting Us – we will get back to you soon!", "status":"success"}
         logger.info('Email sent: ' + info.response)
      }
    });



    res.send("Tutor Requested.thanks for reaching out we will call you back as soon as possible.");
  } else {

    res.send("Something went wrong! Try Again");
  }
});


//=====================================================================================
router.post("/loadMoreTutors", auth, async (req, res) => {
  let limit = parseInt(req.body.limit);
  let start = parseInt(req.body.start);
  const tutorAll = await tutorsMaster.findAll({
    attributes: [
      "id",
      "tutorsFullName",
      "Highquali",
      "subjectExp",
      "tutorFee",
      "addressLocation",
      "profilPic",
      "tutorUrl",
      "Experience"

    ],
    where: {
      status: "true"
    },
    order: [
      ["id", "DESC"]
    ],

    offset: start,
    limit: limit
  });
  res.send(tutorAll);

});


//==========================================================================================

router.get('/autocomplete', async (req, res) => {

  const s = req.query.s.trim();

  const results = [];

  try {
    const products = await Locality.findAll({ where: { localityName: { [Op.like]: `%${s}%` } } });


    products.forEach(product => {
      let { id, localityName } = product;
      results.push(localityName);
    });

  } catch (err) {
    console.log(err);
  }
  res.json(results);
});



router.get("/searchCity", async(req,res)=>{
  let term = req.query.term;
  // console.log(req.query.term+",,,,,,");
  const result = await sequelize.query("select *from cities  where cityName like '%"+term+"%' and status =1");
  // console.log(JSON.stringify(result));
  const resu=result[0];
  var DataList = []
      for (i = 0; i < resu.length; i++) {
        let dataset=resu[i].cityName+","+resu[i].state
        DataList.push(dataset)
      }
  console.log(JSON.stringify(DataList));
      
  res.send(DataList);
});


//====================================Search Locality=========================================

router.post("/searchLocal", async(req,res)=>{
  let term = req.body.term;
  let city =req.body.cit;
  console.log(req.body.term+",,,,,,");
  const result = await sequelize.query("SELECT localityName,pincode,city,state FROM localities where city='"+city+"' and localityName like '%"+term+"%'");
  console.log(JSON.stringify(result));
  const resu=result[0];
  var DataList = []
      for (i = 0; i < resu.length; i++) {
        let dataset=resu[i].localityName+","+resu[i].city+","+resu[i].state+","+resu[i].pincode
        DataList.push(dataset)
      }
      
  res.send(DataList);
});



router.get("/staff-login", auth, async (req, res) => {
  let msg = req.flash("notify");
  if (msg.length > 0) {
    msg = msg[0];
  } else {
    msg = null;
  }

  res.render("loginform", { msg: msg});
});


router.get("/sitemap", auth, async (req, res) => {
  const loca = await Locality.findAll({
    attributes: ['localityName']
  })
  res.render("sitemap", { loca: loca ,allLoc: req.allLoc })
});

router.post("/login", async (req, res) => {

  const email = req.body.email;
  console.log("==email=="+email);
  const userlogin = await User.findOne({ where: { email: email , userType :'s' } });
  if (userlogin) {

    var check = await bcrypt.compare(req.body.password, userlogin.password);
    if (check) {
      req.session.userLoggedin = userlogin;
      console.log(userlogin)
      res.redirect(`${domain}`);

      // res.redirect(`${domain}tutorsprofile/${userlogin.tutorUrl}`);


    } else {

      req.flash("notify", "Invalaid Email or Password");

      res.redirect("/login");
    }
  } else {

    req.flash("notify", "Invalaid Email or Password");

    res.redirect("/login");
  }
});



router.get("/signup", auth, async (req, res) => {
  const loc = await Locality.findAll({
    attributes: ['localityName']
  })
  const sub = await Subjects.findAll({
    attributes: ['SubjectName']
  })

  res.render("signup", { loc: loc, sub: sub ,allLoc: req.allLoc });
});


router.get("/logout", (req, res) => {

  req.session.userLoggedin = "";
  res.redirect("/");
})



router.post("/checkEmail", async (req, res) => {
  const staff = await User.findOne({ where: { email: req.body.email } });
  
  if (staff != null) {

    res.send("1");
  } else {

    res.send("0");
  }
});


router.get("/request-a-tutor", auth, (req, res) => {
  let msg = req.flash("notify");
  if (msg.length > 0) {
    msg = msg[0];
  } else {
    msg = null;
  }
  res.render("instructor", { msg: msg,allLoc: req.allLoc });
});


// ========================================================================
router.post("/request-a-tutor", async (req, res) => {
  let tutReq = await tutorrequest.create({
    Name: req.body.name,
    mobileNumber: req.body.monum,
    message: req.body.message
  });

  if (tutReq._options.isNewRecord) {
    var transporter = nodemailer.createTransport({
      host: "mail.hometutorlucknow.com",
      port: 465,
      secure: true,
      auth: {
        user: 'info@hometutorlucknow.com',
        pass: '9453559003Rp'
      }
    });
    var mailOptions = {
      from: '"Home Tutor 👻" <info@hometutorlucknow.com>',
      to: 'rajs01878@gmail.com,redinkin.lucknow@gmail.com,nekipal1806@gmail.com',
      subject: 'Home Tutor request  lucknow Website',
      html: `Data From WebSite  full name = ${req.body.name} <br/>  Mobile Number = ${req.body.monum} <br/>  message = ${req.body.message}  <br/>   <br/> `
    };
    transporter.sendMail(mailOptions, function (error, info) {
      if (error) {
        logger.error(error);

      } else {
        succ = { "message": "Thank you for contacting Us – we will get back to you soon!", "status": "success" }
        logger.info('Email sent: ' + info.response)
      }
    });

    res.send("Tutor Requested.thanks for reaching out we will call you back as soon as possible.");
  } else {

    res.send("Something went wrong! Try Again");
  }
});






router.get("/jobs-for-you", auth, async (req, res) => {
  if (res.locals.login.prefLocation) {
    let locs = res.locals.login.prefLocation.toString().split(",");
    const teachingJob = await jobsmaster.findAll({
      where: {
        studentLocality: {
          [Op.in]: locs
        }
      },
      order: [
        ["id", "DESC"],],
      limit: 15

    });

    res.render("jobsFor", { data: teachingJob, num: teachingJob.length ,allLoc: req.allLoc });
  } else {
    res.redirect("/login");
  }
});







router.post("/jobappliedbytutors", async (req, res) => {
  const result = await jobAppliedTutors.findOne({
    where: { jobid: req.body.jobid, tutorid: req.body.tutorid }
  });

  if (result != null) {
    res.send("Your are already applied for this job.");
  } else {
    const jobApplied = await jobAppliedTutors.create({
      jobid: req.body.jobid,
      joburl: req.body.joburl,
      tutorid: req.body.tutorid,
      tutorurl: req.body.tutorurl
    });
    if (jobApplied._options.isNewRecord = true) {
      res.send("Thanks For Appling for this job.");
    } else {
      res.send("Somthing Went Wrong!");
    }
  }

});



router.get("/search", auth, async (req, res) => {

  let locality = req.query.locality;

  let tutorAll = await tutorsMaster.findAll({
    attributes: [
      "id",
      "tutorsFullName",
      "Highquali",
      "subjectExp",
      "tutorFee",
      "addressLocation",
      "profilPic",
      "tutorUrl",
      "Experience"

    ],
    where: {
      status: "true",
      prefLocation: { [Op.like]: `%${locality}%` }
    },
    order: [

      [sequelize.fn('COALESCE', sequelize.col('rank'), 'NULL'), 'ASC'],
      ['id', 'DESC']
    ]
  });
  if (tutorAll.length == 0) {
    tutorAll = await getAllTutors();
    noOfRes = "Tutors Not Found in " + locality + " Call On +917007045454 For More Details";
  } else {
    noOfRes = tutorAll.length + " tutors found in " + locality;
  }
  res.render("searchResult", { data: tutorAll, noofres: noOfRes, local: locality,allLoc: req.allLoc });

});




router.post("/postRev",async(req,res)=>{
  let revs = await reviewMst.create({
      reviewerName:req.body.revName,
      mobileNumber:req.body.revmonum,
      reviewSummary:req.body.review,
      stars: req.body.finstar,
      tutorId:req.body.tutorId
    });
  res.status(200).send("Review Sucessfully Posted.");
});

//=============================================tutor jobs=============================================================================
router.get("/tutorjobs", auth, async (req, res) => {

  let locality = req.query.in;
  const teachingJob = await jobsmaster.findAll({
    where: {
      studentLocality: { [Op.like]: `%${locality}%` }
    },
    order: [
      ["id", "DESC"],],
  });
  const jobsNumber = await teachingJob.length;
  res.render("jobs-result", { data: teachingJob, num: jobsNumber,loc:locality,allLoc: req.allLoc });

});


//============================================= Staff by city or locality===========================================================


router.get('/:city/:locality/:stafftype', async (req, res) => {
  let { city, locality, stafftype } = req.params;
  console.log("=========================="+city+locality+stafftype);

  locality = locality.replace(/-/g, " ");

  stafftype = stafftype.split("-")[0];
  let landingPageLimit =30;
  const page = +req.query.page || 1;

  try {
    if (stafftype && locality) {
      // Case: /:city/:locality/:stafftype
      
      staffMaster.belongsTo(User, { foreignKey: 'userId' });
  User.hasOne(staffMaster, { foreignKey: 'userId' });
  
      const {count,rows} = await staffMaster.findAndCountAll({
        attributes: [
          'userId', 
          'StaffDesig', 
          'Experience', 
          'staffCharges', 
          'StaffQuali',
          'profilPic', 
          'staffUrl', 
          'addressLocation'
        ],
        include: [{
          model: User,
          attributes: ['fullname', ['city', 'city']],  // Alias for city
        }],
        where: {
          
          StaffDesig:{
            [Op.like]: '%'+stafftype+'%'
          },
          prefLocation:{
            [Op.like]:'%'+locality+'%'
          },
          city:city,
          status:"true"
          
        },
        order: [['createdAt', 'DESC']],  // Order by userId in ascending order
        limit: landingPageLimit,  // Limit to 12 results
        offset: ((page-1)*landingPageLimit)   // Offset by 1
      });


       res.render("staffList.ejs",{data:rows,count,stafftype,city,locality});
      
    }else {
      // Case: /:city
      // const result = `Displaying all staff in ${city}`;
      res.redirect('404');
    }
  } catch (error) {
    console.error(error);
    res.status(500).send("Server Error");
  }
});
// =====================================================================================


router.get('/:city/:stafftype', async (req, res) => {
  let { city, stafftype } = req.params;
    stafftype = stafftype.split("-")[0];
  let landingPageLimit =30;
  const page = +req.query.page || 1;
  console.log("in city type");
  staffMaster.belongsTo(User, { foreignKey: 'userId' });
  User.hasOne(staffMaster, { foreignKey: 'userId' });
  
      const {count,rows} = await staffMaster.findAndCountAll({
        attributes: [
          'userId', 
          'StaffDesig', 
          'Experience', 
          'staffCharges', 
          'StaffQuali',
          'profilPic', 
          'staffUrl', 
          'addressLocation'
        ],
        include: [{
          model: User,
          attributes: ['fullname', ['city', 'city']],  // Alias for city
        }],
        where: {
          
          StaffDesig:{
            [Op.like]: '%'+stafftype+'%'
          },
          city:city,
          status:"true"
          
        },
        order: [['createdAt', 'DESC']],  // Order by userId in ascending order
        limit: landingPageLimit,  // Limit to 12 results
        offset: ((page-1)*landingPageLimit)   // Offset by 1
      });

  res.render("staffList.ejs",{data:rows,count,city,stafftype,locality:""});


})


//=============================================================================================================================
router.get("/:id", auth, async (req, res) => {


        // Define the relationship between User and staffMaster
    User.hasMany(staffMaster, { foreignKey: 'userId' });
    staffMaster.belongsTo(User, { foreignKey: 'userId'});
          
          // users model (representing users table)
    const result = await staffMaster.findOne({
      where: {
        staffUrl: ""+req.params["id"] // Filtering where tutorUrl is an empty string
      },
      include: [
        {
          model: User       // Model to join with
        
        }
      ]
    });
    console.log(JSON.stringify(result));
  if(result){
    res.render("staffProfile",{data:result});
  }else{
    res.redirect("/404");
  }

});

module.exports = router;